-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.raidIron:LinkToTarget("raid")
    self.raidStone:LinkToTarget("raid")
    
    if not self.loaded then
      self.riActive = false
      self.rsActive = false
      self.raidILimit = 120
      self.raidSLimit = 120
      self.raidITimer = self.raidILimit
      self.raidSTimer = self.raidSLimit
    end
  end
  
  self.td = Timer:GetTimeDiff()
  
  if self.riActive then
    self.raidITimer = self.raidITimer - self.td
    if self.raidITimer <= 0 then
      self.raidIron:TriggerAllTargets()
      self.raidILimit = self.raidILimit * 1.25
      self.raidITimer = self.raidILimit
    end
  end
  
  if self.rsActive then
    self.raidSTimer = self.raidSTimer - self.td
    if self.raidSTimer <= 0 then
      self.raidStone:TriggerAllTargets()
      self.raidSLimit = self.raidSLimit * 1.25
      self.raidSTimer = self.raidSLimit
    end
  end  
end

function OnTrigger(self, soruce, target)
  if target == "riActive" then
    self.riActive = true
  elseif target == "rsActive" then
    self.rsActive = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.riActive = ar:Read()
    self.rsActive = ar:Read()
    self.raidILimit = ar:Read()
    self.raidSLimit = ar:Read()
    self.raidITimer = ar:Read()
    self.raidSTimer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.riActive)
    ar:Write(self.rsActive)
    ar:Write(self.raidILimit)
    ar:Write(self.raidSLimit)
    ar:Write(self.raidITimer)
    ar:Write(self.raidSTimer)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("riActive")
  self:AddTriggerTarget("rsActive")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("raidIron")
  self:AddTriggerSource("raidStone")
end
